<?php
session_start();

// Include the database configuration file
include 'headeradmin.php';
include 'config.php';

// Check if PDO connection was successful (optional)
if (!$pdo) {
    die("Connection failed: " . $pdo->errorInfo());
}

// Check if user is logged in and has status 2
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$user_id = $_SESSION['user_id'];

try {
    // Prepare and execute the SQL query to check user status
    $stmt = $pdo->prepare("SELECT status FROM users WHERE id = :id");
    $stmt->bindParam(':id', $user_id, PDO::PARAM_INT);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user || $user['status'] != 2) {
        header('Location: login.php');
        exit();
    }

    // Prepare and execute the SQL query for users data
    $sql = "SELECT u.id, u.username, u.password, u.email, u.contact_number, u.full_name, u.mt5username, 
                   u.status, COALESCE(u.investment, 0) AS investment, COALESCE(u.percentage, 0) AS percentage,
                   COALESCE(ui.balance, 0) AS balance, COALESCE(ui.equity, 0) AS equity, COALESCE(ui.profit, 0) AS profit,
                   COALESCE(ui.margin, 0) AS margin, COALESCE(ui.open_trades, '') AS open_trades, 
                   COALESCE(ui.timestamp, u.timestamp) AS timestamp, COALESCE(ui.online, u.online) AS online
            FROM users u
            LEFT JOIN userinfo ui ON u.mt5username = ui.mt5username
            ORDER BY u.mt5username";

    $stmt = $pdo->prepare($sql);
    $stmt->execute();

    // Fetch the results
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    echo 'Query failed: ' . $e->getMessage();
    exit; // Stop the script if query fails
}

// Function to format the open trades
function formatOpenTrades($trades) {
    // Remove unwanted fields
    $trades = preg_replace('/Volume:\s*\d+(\.\d+)?\s*/i', '', $trades); // Remove 'Volume:'
    $trades = preg_replace('/Open Price:\s*\d+(\.\d+)?\s*/i', '', $trades); // Remove 'Open Price:'
    $trades = preg_replace('/Stop Loss:\s*\d+(\.\d+)?\s*/i', '', $trades); // Remove 'Stop Loss:'
    $trades = preg_replace('/Take Profit:\s*\d+(\.\d+)?\s*/i', '', $trades); // Remove 'Take Profit:'
    
    // Extract and format the relevant parts
    $trades = preg_replace('/\s*Symbol:\s*/i', "", $trades); // Remove 'Symbol:'
    $trades = preg_replace('/\s*(\w+)\s*(SL:\s*\d+(\.\d+)?\s*)?(TP:\s*\d+(\.\d+)?\s*)?(Profit:\s*\d+(\.\d+)?\s*)?(Buy|Sell)\s*/i', 
                            "$1 £$7 $8", $trades);

    // Remove 'Timestamp' and any trailing timestamps
    $trades = preg_replace('/\b(Time|Timestamp):.*?\n?/i', '', $trades);
    $trades = preg_replace('/\s*\d{4}\.\d{2}\.\d{2}\s\d{2}:\d{2};\s*/', '', $trades); // Remove timestamp format like '2024.09.15 03:11;'

    // Remove commas and extra spaces
    $trades = preg_replace('/,\s*/', ' ', $trades); // Remove commas
    $trades = preg_replace('/Type:\s*/i', '', $trades); // Remove 'Type:'
    $trades = preg_replace('/\s{2,}/', ' ', $trades); // Replace multiple spaces with a single space

    // Replace 'Profit:' with '£'
    $trades = preg_replace('/Profit:\s*/i', '£', $trades);

    // Ensure each trade ends with a line break after 'Buy' or 'Sell'
    $trades = preg_replace('/\s*(Buy|Sell)\s*/i', ' $1<br>', $trades);

    // Remove trailing line breaks
    $trades = preg_replace('/<br\s*\/?>\s*$/', '', $trades); // Remove trailing <br> tags

    return $trades;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        /* Container for the table */
        .container2 {
            width: 90%;
            margin: 20px auto;
            padding: 20px;
            background: #081012; /* Dark background for the container */
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);
            overflow-x: auto; /* Enable horizontal scrolling if needed */
            position: relative; /* Make container a reference for pop-up positioning */
            margin-top: 100px;
        }

        /* Table styling */
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 16px;
        }

        th, td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #444;
        }

        th {
            background-color: #1a2021;
            color: #d4af37; /* Creamy gold text for headers */
            font-size: 20px;
        }

        tr:nth-child(even) {
            background-color: #0f1819;
        }

        tr:hover {
            background-color: #444;
        }

        .open-trades {
            white-space: pre-line; /* To handle line breaks in open trades */
            font-family: 'Poppins', sans-serif;
            overflow-wrap: break-word; /* Ensure long words are broken properly */
        }

        .open-trades b {
            font-weight: 600;
        }

        /* Add User Button */
        .add-user-btn {
            display: inline-block;

            margin-bottom: 5px;
            padding: 10px 20px;
            background-color: #004d00; /* Darker green background */
            color: white;
            border: none;
            border-radius: 10px; /* Matching border radius style */
            font-size: 16px;
            cursor: pointer;
            text-align: center;
            font-family: 'Poppins', sans-serif;
            text-decoration: none;
            position: relative; /* Adjust positioning context */
            float: right; /* Align to the far right */
            transition: background-color 0.3s ease; /* Smooth color transition */
        }

        .add-user-btn:hover {
            background-color: #003300; /* Even darker green on hover */
        }

        /* Pop-up form */
        .popup-form {
            display: none;
            position: fixed; /* Fixed positioning for overlay effect */
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%); /* Center the popup */
            width: 400px;
            background-color: #fff;
            padding: 20px;
            border-radius: 20px; /* Matching border radius style */
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.3);
            z-index: 1000;
        }

        .popup-form h2 {
            margin-top: 0;
            font-family: 'Poppins', sans-serif;
            color: #6f6242; /* Matching color for headers */
        }

        .popup-form input {
            width: calc(100% - 22px);
            padding: 10px;
            margin: 10px 0;
            border: 2px solid #d7d1ac; /* Matching border style */
            border-radius: 20px; /* Matching border radius style */
            font-size: 16px;
            background-color: #f9f9f9;
        }

        .popup-form button {
            width: 100%;
            padding: 10px;
            border: none;
            border-radius: 20px; /* Matching border radius style */
            background-color: #004d00; /* Darker green background */
            color: white;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s ease; /* Smooth color transition */
        }

        .popup-form button:hover {
            background-color: #003300; /* Even darker green on hover */
        }

        /* Overlay background */
        .overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 999; /* Just below the popup */
        }

        /* Modal Open button */
        .open-modal-btn {
            margin-top: 20px;
            padding: 10px 20px;
            background-color: #004d00; /* Darker green background */
            color: white;
            border: none;
            border-radius: 10px; /* Matching border radius style */
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s ease; /* Smooth color transition */
            text-decoration: none;
            display: inline-block;
        }

        .open-modal-btn:hover {
            background-color: #003300; /* Even darker green on hover */
        }
        /* Base styles for mobile devices */
body {
    font-size: 16px; /* Base font size */
    zoom: 1; /* Ensure zoom is normal */
    margin-top: 50px;
}


/* Adjust font size and zoom for smaller screens */
@media only screen and (max-width: 600px) {
    body {
        font-size: 14px; /* Smaller font size for smaller screens */
        zoom: 0.8; /* Slightly zoom out to fit content */
        
    }
            .container2 {
                    zoom: 0.4; /* Slightly zoom out to fit content */

            }
}


    </style>
</head>
<body>
    <div class="container2">
        <h2>All Accounts - Raw data no percentages taken</h2>
        <a href="#" class="open-modal-btn" id="openModal">Add User</a>
        <div class="popup-form" id="popupForm">
            <h2>Add New User</h2>
            <form method="post" action="add_user.php">
                <input type="text" name="username" placeholder="Username" required>
                <input type="password" name="password" placeholder="Password" required>
                <input type="email" name="email" placeholder="Email" required>
                <input type="text" name="contact_number" placeholder="Contact Number" required>
                <input type="text" name="full_name" placeholder="Full Name" required>
                <input type="text" name="mt5username" placeholder="MT5 Username" required>
                <input type="number" name="status" placeholder="Status (e.g., 2)" required>
                <button type="submit">Add User</button>
            </form>
        </div>
        <div class="overlay" id="overlay"></div>

<table>
    <thead>
        <tr>
            <th>ID</th>
            <th>Username</th>
            <th>MT5 Username</th>
            <th>Investment</th>
            <th>Percentage</th>
            <th>Balance</th>
            <th>Profit</th>
            <th>Open Trades</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($results as $row): ?>
            <tr onclick="window.location.href='user_details.php?id=<?php echo htmlspecialchars($row['id']); ?>'">
                <td><?php echo htmlspecialchars($row['id']); ?></td>
                <td><?php echo htmlspecialchars($row['username']); ?></td>
                <td><?php echo htmlspecialchars($row['mt5username']); ?></td>
                <td><?php echo htmlspecialchars($row['investment']); ?></td>
                <td><?php echo htmlspecialchars($row['percentage']); ?></td>
                <td><?php echo htmlspecialchars($row['balance']); ?></td>
                <td><?php echo htmlspecialchars($row['profit']); ?></td>
                <td class="open-trades"><?php echo formatOpenTrades($row['open_trades']); ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

    </div>

    <script>
        document.getElementById('openModal').addEventListener('click', function () {
            document.getElementById('popupForm').style.display = 'block';
            document.getElementById('overlay').style.display = 'block';
        });

        document.getElementById('overlay').addEventListener('click', function () {
            document.getElementById('popupForm').style.display = 'none';
            document.getElementById('overlay').style.display = 'none';
        });
    </script>
</body>
</html>
